************************************************************************************************
* Name			: table D2 - impacts of the intervention on investments in the full and restricted samples 
*
* Description	: This dofile estimates impacts of the stimulation component of the intervention on the 
*                 full sample and the sample restricted to households where the data collected was more 
* 				  than four days after the last home visit 
************************************************************************************************

********************************************************************************
* SETTINGS 
********************************************************************************
clear 				all 
set more 			off 
set graphics 		off 
version 			15          /*Use Stata 15*/ 
set seed			16072015   	/* This is the seed number that was used to create the bootstrapped samples for estimation of the model in the paper */ 

* Options for data to create 
global testerFE 	no 			/*Take out tester FE before standardizing measures*/ 
global invar 		no 			/*Incorporate intercepts in the measurement system for when we will allow for measurement system variance*/ 
global pure 		no 			/*Only pure control and pure stimulation groups*/ 

* Globals of directories, variable groups and others 
run "$dir_statacode\globals.do" 

* Dataset with standardized measures 
use "$dir_data\measures.dta", clear 


********************************************************************************
* CREATE FLAG FOR RESTRICTED SAMPLE 
********************************************************************************
gen lapse_hh_survey_last_hv = date_survey_fu1 - stim_date_last_visit1

gen flag =(lapse_hh_survey_last_hv >3 & treat==2)
replace flag =1 if treat==1 


********************************************************************************
* PANEL A - TREATMENT EFFECTS ON MATERIAL INVESTMENTS IN THE TWO SAMPLES 
********************************************************************************
local fcimat "fci_play_mat_type Npaintbooks Nthingsmove Ntoysshape Ntoysbought"
foreach y of local fcimat{
local append "append"
if "`y'"=="fci_play_mat_type" local append "replace" 
	
	cap drop V*
	reg `y'1_st treat fci_play_mat_type0_st $covs_ent , cl(cod_dane)
	outreg2 using "$dir_output/TableD2.xls", `append' $outregopt ctitle("`y'") 
	
	reg `y'1_st treat fci_play_mat_type0_st $covs_ent if flag==1, cl(cod_dane)
	outreg2 using "$dir_output/TableD2.xls", append $outregopt ctitle("`y'")  
} 

********************************************************************************
* PANEL B - TREATMENT EFFECTS ON TIME INVESTMENTS IN THE TWO SAMPLES 
********************************************************************************
local fcitime "fci_play_act home_stories home_read home_toys home_name"
foreach y of local fcitime{
	cap drop V*
	reg `y'1_st treat fci_play_act0_st $covs_ent , cl(cod_dane)
	outreg2 using "$dir_output/TableD2.xls", append $outregopt ctitle("`y'")  
	
	reg `y'1_st treat fci_play_act0_st $covs_ent if flag==1 , cl(cod_dane)
	outreg2 using "$dir_output/TableD2.xls", append $outregopt ctitle("`y'") 
} 

